/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.services.binding;

import com.mathworks.mwswing.binding.DefaultKeyBindingSet;
import com.mathworks.mwswing.binding.KeyBindingManager;
import com.mathworks.mwswing.binding.Serializer;
import com.mathworks.services.KeyboardPrefs;
import com.mathworks.util.Log;
import com.mathworks.util.PlatformInfo;
import java.io.InputStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatlabKeyBindings {
    public static final String EDITOR_CONTEXT_ID = "MATLABEditor";
    public static final String DESKTOP_CONTEXT_ID = "MATLABDesktop";
    public static final String COMMAND_WINDOW_CONTEXT_ID = "CommandWindow";
    public static final String COMMAND_HISTORY_CONTEXT_ID = "CommandHistory";
    public static final String EXPLORER_CONTEXT_ID = "Explorer";
    public static final String COPY_ID = "copy-to-clipboard";
    public static final String CUT_ID = "cut-to-clipboard";
    public static final String PASTE_ID = "paste-from-clipboard";
    public static final String PASTE_TO_WORKSPACE_ID = "paste-to-workspace";
    public static final String IMPORT_DATA_ID = "import-data";
    public static final String UNDO_ID = "undo";
    public static final String REDO_ID = "redo";
    public static final String RENAME_ID = "rename";
    public static final String SELECT_ALL_ID = "select-all";
    public static final String KILL_LINE_ID = "kill-line";
    public static final String CLEAR_SELECTION_ID = "unselect";
    public static final String DELETE_PREVIOUS_ID = "delete-previous";
    public static final String DELETE_NEXT_ID = "delete-next";
    public static final String INC_SEARCH_FORWARD_ID = "inc-search-forward";
    public static final String INC_SEARCH_BACKWARD_ID = "inc-search-backward";
    public static final String INSERT_BREAK_ID = "insert-break";
    public static final String SHIFT_INSERT_BREAK_ID = "shift-insert-break";
    public static final String CARET_FORWARD_ID = "caret-forward";
    public static final String CARET_BACKWARD_ID = "caret-backward";
    public static final String CARET_DOWN_ID = "caret-down";
    public static final String CARET_UP_ID = "caret-up";
    public static final String SELECTION_FORWARD_ID = "selection-forward";
    public static final String SELECTION_BACKWARD_ID = "selection-backward";
    public static final String SELECTION_DOWN_ID = "selection-down";
    public static final String SELECTION_UP_ID = "selection-up";
    public static final String CARET_NEXT_WORD_ID = "caret-next-word";
    public static final String CARET_PREVIOUS_WORD_ID = "caret-previous-word";
    public static final String SELECTION_NEXT_WORD_ID = "selection-next-word";
    public static final String SELECTION_PREVIOUS_WORD_ID = "selection-previous-word";
    public static final String SCROLL_UP_ID = "scroll-up";
    public static final String SCROLL_DOWN_ID = "scroll-down";
    public static final String PAGE_UP_ID = "page-up";
    public static final String PAGE_DOWN_ID = "page-down";
    public static final String SELECTION_PAGE_UP_ID = "selection-page-up";
    public static final String SELECTION_PAGE_DOWN_ID = "selection-page-down";
    public static final String CARET_BEGIN_LINE_ID = "caret-begin-line";
    public static final String CARET_END_LINE_ID = "caret-end-line";
    public static final String CARET_BEGIN_ID = "caret-begin";
    public static final String CARET_END_ID = "caret-end";
    public static final String SELECTION_BEGIN_LINE_ID = "selection-begin-line";
    public static final String SELECTION_END_LINE_ID = "selection-end-line";
    public static final String SELECTION_BEGIN_ID = "selection-begin";
    public static final String SELECTION_END_ID = "selection-end";
    public static final String TOGGLE_TYPING_MODE_ID = "toggle-typing-mode";
    public static final String REMOVE_NEXT_WORD_ID = "remove-word-next";
    public static final String NEW_M_FILE_ID = "new-mfile";
    public static final String NEW_M_FUNCTION_ID = "new-mfunction";
    public static final String NEW_M_CLASS_ID = "new-mclass";
    public static final String NEW_PROJECT_ID = "new-project";
    public static final String NEW_FIGURE_ID = "new-figure";
    public static final String NEW_VARIABLE_ID = "new-variable";
    public static final String NEW_MODEL_ID = "new-model";
    public static final String NEW_GUI_ID = "new-gui";
    public static final String OPEN_NEW_ID = "open-new";
    public static final String LAUNCH_SIMULINK_ID = "launch-simulink";
    public static final String LAUNCH_GUIDE_ID = "launch-guide";
    public static final String LAUNCH_PROFILER_ID = "launch-profiler";
    public static final String EXIT_MATLAB_ID = "exit-matlab";
    public static final String CLOSE_ITEM_ID = "close-item";
    public static final String CLOSE_GROUP_ID = "close-group";
    public static final String SAVE_ID = "save";
    public static final String SAVE_AS_ID = "save-as";
    public static final String SAVE_ALL_ID = "save-all";
    public static final String SET_PATH_ID = "set-path";
    public static final String SHOW_PREFERENCES_ID = "show-preferences";
    public static final String FIND_ID = "find-and-replace";
    public static final String FIND_NEXT_ID = "find-next";
    public static final String FIND_PREVIOUS_ID = "find-previous";
    public static final String FIND_SELECTION_ID = "find-selection";
    public static final String FIND_PREVIOUS_SELECTION__ID = "find-previous-selection";
    public static final String EVALUATE_SELECTION_ID = "evaluate-selection";
    public static final String PRINT_SELECTION_ID = "print-selection";
    public static final String OPEN_SELECTION_ID = "open-selection";
    public static final String HELP_ON_SELECTION_ID = "help-on-selection";
    public static final String PRODUCT_HELP_ID = "product-help";
    public static final String LAUNCH_HELP_BROWSER_ID = "show-help-browser";
    public static final String DEMOS_ID = "show-demos";
    public static final String SET_CLEAR_BKPT_ID = "set-clear-breakpoint";
    public static final String GO_UNTIL_CURSOR_ID = "go-until-cursor";
    public static final String PRINT_ID = "print";
    public static final String PAGE_SETUP_ID = "show-page-setup";
    public static final String DEBUG_CONTINUE_ID = "debug-continue";
    public static final String DEBUG_STEP_IN_ID = "debug-step-in";
    public static final String DEBUG_STEP_ID = "debug-step";
    public static final String DEBUG_STEP_OUT_ID = "debug-step-out";
    public static final String EXIT_DEBUG_ID = "exit-debug";
    public static final String CLEAR_ALL_BKPTS_ID = "clear-all-breakpoints";
    public static final String SHOW_STOP_IF_DIALOG_ID = "show-stop-if-dialog";
    public static final String TOGGLE_GRAPHICAL_DEBUGGING_ID = "toggle-graphical-debugging";
    public static final String ADJUST_WINDOW_TOP_ID = "adjust-window-top";
    public static final String ADJUST_WINDOW_BOTTOM_ID = "adjust-window-bottom";
    public static final String FIND_FILES_ID = "find-files";
    public static final String GOTO_LINE_ID = "goto-line";
    public static final String INSERT_TAB_ID = "insert-tab";
    public static final String SAVE_WORKSPACE_ID = "save-workspace";
    public static final String BEEP_ID = "beep";
    public static final String PREVIOUS_LOCATION_ID = "jump-list-prev";
    public static final String NEXT_LOCATION_ID = "jump-list-next";
    public static final String CLEAR_COMMAND_HISTORY_ID = "clear-command-history";
    public static final String CLEAR_COMMAND_WINDOW_ID = "clear-command-window";
    public static final String CLEAR_WORKSPACE_ID = "clear-workspace";
    public static final String CREATE_M_FILE_FROM_SELECTION_ID = "create-mfile-from-selection";
    public static final String CREATE_SHORTCUT_FROM_SELECTION_ID = "create-shortcut-from-selection";
    public static final String PROFILE_SELECTED_TEXT_ID = "profile-selected-code";
    public static final String REFRESH_ID = "refresh";
    public static final String OPEN_FUNCTION_BROWSER_ID = "function-browser-key";
    private static final KeyBindingManager sManager = new KeyBindingManager();
    public static final String EMACS_MAC_CUSTOM_SET = "DefaultMathWorksEmacsMacSet";
    public static final String WINDOWS_MAC_CUSTOM_SET = "DefaultMathWorksWindowsMacSet";
    public static final String CMD_WIN_EMACS_EDITOR_WINDOWS_CUSTOM_SET = "CmdWinEmacsEditorWindowsSet";
    public static final String CMD_WIN_EMACS_EDITOR_WINDOWS_MAC_CUSTOM_SET = "CmdWinEmacsEditorWindowsMacSet";
    public static final String CMD_WIN_EMACS_EDITOR_MAC_CUSTOM_SET = "CmdWinEmacsEditorMacSet";
    public static final String CMD_WIN_WINDOWS_EDITOR_EMACS_CUSTOM_SET = "CmdWinWindowsEditorEmacsSet";
    public static final String CMD_WIN_WINDOWS_EDITOR_EMACS_MAC_CUSTOM_SET = "CmdWinWindowsEditorEmacsMacCustomSet";
    public static final String CMD_WIN_WINDOWS_EDITOR_MAC_CUSTOM_SET = "CmdWinWindowsEditorMacCustomSet";
    public static final String CMD_WIN_MAC_EDITOR_WINDOWS_MAC_CUSTOM_SET = "CmdWinMacEditorWindowsSet";
    public static final String CMD_WIN_MAC_EDITOR_EMACS_MAC_CUSTOM_SET = "CmdWinMacEditorEmacsSet";
    private static final StringBuffer sErrors = new StringBuffer();

    private static void readFilesFromXML() throws Serializer.ReadWriteException {
        Object object;
        InputStream inputStream = MatlabKeyBindings.class.getResourceAsStream("resources/ActionAndContextFiles.xml");
        Element element = Serializer.getTopElement((InputStream)inputStream, (String)"Files");
        List<String> list = MatlabKeyBindings.getEntries("ActionFiles", element);
        for (String object22 : list) {
            object = MatlabKeyBindings.class.getResourceAsStream(object22);
            if (object == null) {
                sErrors.append("Unable to find action file '").append(object22).append("'.\n");
                continue;
            }
            sManager.parseAndRegisterActions((InputStream)object);
        }
        List<String> list2 = MatlabKeyBindings.getEntries("ContextFiles", element);
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            InputStream inputStream2 = MatlabKeyBindings.class.getResourceAsStream((String)object);
            if (inputStream2 == null) {
                sErrors.append("Unable to find context file '").append((String)object).append("'.\n");
                continue;
            }
            sManager.parseAndRegisterContexts(inputStream2);
        }
    }

    private static List<String> getEntries(String string, Element element) {
        LinkedList<String> linkedList = new LinkedList<String>();
        NodeList nodeList = element.getElementsByTagName(string);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            NodeList nodeList2 = nodeList.item(i).getChildNodes();
            for (int j = 0; j != nodeList2.getLength(); ++j) {
                if (!nodeList2.item(j).getNodeName().equals("entry")) continue;
                linkedList.add(nodeList2.item(j).getTextContent());
            }
        }
        return linkedList;
    }

    private MatlabKeyBindings() {
    }

    public static KeyBindingManager getManager() {
        return sManager;
    }

    public static String getIDBasedOnPref(int n, int n2) {
        String string;
        if (n == 2) {
            if (n2 == 0) {
                string = PlatformInfo.isMacintosh() ? EMACS_MAC_CUSTOM_SET : DefaultKeyBindingSet.EMACS.getID();
            } else if (n2 == 2) {
                string = CMD_WIN_MAC_EDITOR_EMACS_MAC_CUSTOM_SET;
            } else {
                assert (n2 == 1);
                string = PlatformInfo.isMacintosh() ? CMD_WIN_WINDOWS_EDITOR_EMACS_MAC_CUSTOM_SET : CMD_WIN_WINDOWS_EDITOR_EMACS_CUSTOM_SET;
            }
        } else if (n == 1) {
            if (n2 == 0) {
                string = PlatformInfo.isMacintosh() ? CMD_WIN_EMACS_EDITOR_WINDOWS_MAC_CUSTOM_SET : CMD_WIN_EMACS_EDITOR_WINDOWS_CUSTOM_SET;
            } else if (n2 == 2) {
                string = CMD_WIN_MAC_EDITOR_WINDOWS_MAC_CUSTOM_SET;
            } else {
                assert (n2 == 1);
                string = PlatformInfo.isMacintosh() ? WINDOWS_MAC_CUSTOM_SET : DefaultKeyBindingSet.WINDOWS.getID();
            }
        } else {
            assert (n == 3);
            if (n2 == 0) {
                string = CMD_WIN_EMACS_EDITOR_MAC_CUSTOM_SET;
            } else if (n2 == 2) {
                string = DefaultKeyBindingSet.MAC.getID();
            } else {
                assert (n2 == 1);
                string = CMD_WIN_WINDOWS_EDITOR_MAC_CUSTOM_SET;
            }
        }
        return string;
    }

    public static String getErrors() {
        return sErrors.toString();
    }

    static {
        try {
            MatlabKeyBindings.readFilesFromXML();
            sManager.parseAndRegisterCustomKeyBindingSet(EMACS_MAC_CUSTOM_SET, "EmacsMacSet", MatlabKeyBindings.class.getResourceAsStream("resources/EmacsMacCustomSet.xml"));
            sManager.parseAndRegisterCustomKeyBindingSet(WINDOWS_MAC_CUSTOM_SET, "WindowsMacSet", MatlabKeyBindings.class.getResourceAsStream("resources/WindowsMacCustomSet.xml"));
            sManager.parseAndRegisterCustomKeyBindingSet(CMD_WIN_EMACS_EDITOR_WINDOWS_CUSTOM_SET, CMD_WIN_EMACS_EDITOR_WINDOWS_CUSTOM_SET, MatlabKeyBindings.class.getResourceAsStream("resources/CmdWinEmacsEditorWindowsCustomSet.xml"));
            sManager.parseAndRegisterCustomKeyBindingSet(CMD_WIN_EMACS_EDITOR_WINDOWS_MAC_CUSTOM_SET, CMD_WIN_EMACS_EDITOR_WINDOWS_MAC_CUSTOM_SET, MatlabKeyBindings.class.getResourceAsStream("resources/CmdWinEmacsEditorWindowsMacCustomSet.xml"));
            sManager.parseAndRegisterCustomKeyBindingSet(CMD_WIN_EMACS_EDITOR_MAC_CUSTOM_SET, CMD_WIN_EMACS_EDITOR_MAC_CUSTOM_SET, MatlabKeyBindings.class.getResourceAsStream("resources/CmdWinEmacsEditorMacCustomSet.xml"));
            sManager.parseAndRegisterCustomKeyBindingSet(CMD_WIN_WINDOWS_EDITOR_EMACS_CUSTOM_SET, CMD_WIN_WINDOWS_EDITOR_EMACS_CUSTOM_SET, MatlabKeyBindings.class.getResourceAsStream("resources/CmdWinWindowsEditorEmacsCustomSet.xml"));
            sManager.parseAndRegisterCustomKeyBindingSet(CMD_WIN_MAC_EDITOR_WINDOWS_MAC_CUSTOM_SET, CMD_WIN_MAC_EDITOR_WINDOWS_MAC_CUSTOM_SET, MatlabKeyBindings.class.getResourceAsStream("resources/CmdWinMacEditorWindowsCustomSet.xml"));
            sManager.parseAndRegisterCustomKeyBindingSet(CMD_WIN_MAC_EDITOR_EMACS_MAC_CUSTOM_SET, CMD_WIN_MAC_EDITOR_EMACS_MAC_CUSTOM_SET, MatlabKeyBindings.class.getResourceAsStream("resources/CmdWinMacEditorEmacsCustomSet.xml"));
            sManager.parseAndRegisterCustomKeyBindingSet(CMD_WIN_WINDOWS_EDITOR_EMACS_MAC_CUSTOM_SET, CMD_WIN_WINDOWS_EDITOR_EMACS_MAC_CUSTOM_SET, MatlabKeyBindings.class.getResourceAsStream("resources/CmdWinWindowsEditorEmacsMacCustomSet.xml"));
            sManager.parseAndRegisterCustomKeyBindingSet(CMD_WIN_WINDOWS_EDITOR_MAC_CUSTOM_SET, CMD_WIN_WINDOWS_EDITOR_EMACS_MAC_CUSTOM_SET, MatlabKeyBindings.class.getResourceAsStream("resources/CmdWinWindowsEditorMacCustomSet.xml"));
            sManager.setCurrentKeyBindingSet(MatlabKeyBindings.getIDBasedOnPref(KeyboardPrefs.getEditorKeybindingScheme(), KeyboardPrefs.getCmdWinKeybindingScheme()));
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            Log.logException((Exception)exception);
        }
    }
}

