/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.services;

import com.mathworks.services.PrefChangeListener;
import com.mathworks.services.PrefEvent;
import com.mathworks.services.PrefListener;
import com.mathworks.services.PrefsAWT;
import com.mathworks.services.RGBInteger;
import com.mathworks.util.CharBuffer;
import com.mathworks.util.FileUtils;
import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;

public class Prefs {
    public static final String CODEPAD = "Codepad";
    public static final String DOCUMENTS = "Documents";
    public static final String COMMAND_WINDOW = "CommandWindow";
    public static final String SESSION_SIZE = "SessionSize";
    public static final String MIN_SESSION_SIZE = "MinSessionSize";
    public static final String TAB_COMPLETION = "TabCompletion";
    public static final String FUNCTION_HINTS = "FunctionHints";
    public static final String MAX_COMPLETIONS = "MaxCompletions";
    public static final String WRAP_LINES = "WrapLines";
    public static final String PRINT_OPTIONS = "PrintOptions";
    public static final String TEXT_FONT = "TextFont";
    public static final String HEADER_FONT = "HeaderFont";
    public static final String LINE_NUMBER_FONT = "LineNumberFont";
    public static final String HISTORY_OPTIONS = "HistoryOptions";
    public static final String TAB_NARROWS = "TabNarrows";
    public static final String COMMAND_HISTORY = "CommandHistory";
    public static final String SAVE_LINES = "SaveLines";
    public static final String EDITOR = "Editor";
    public static final String BUILTIN_EDITOR = "BuiltinEditor";
    public static final String OTHER_EDITOR = "OtherEditor";
    public static final String SHOW_TOOLBAR = "ShowToolbar";
    public static final String SHOW_LINE_NUMBERS = "ShowLineNumbers";
    public static final String GRAPHICAL_DEBUGGING = "GraphicalDebugging";
    public static final String SYNTAX_HIGHLIGHTING = "SyntaxHighlighting";
    public static final String KEY_BINDING_SCHEME = "KeyBindingScheme";
    public static final String INLINE_DEBUGGER = "InlineDebugger";
    public static final String TAB_MODE = "TabMode";
    public static final String SOURCE_CONTROL_SYSTEM = "SourceControlSystem";
    public static final String SPACES_PER_TAB = "SpacesPerTab";
    public static final String EDITOR_FONT = "Font";
    public static final String BACKGROUND_COLOR = "BackgroundColor";
    public static final String TEXT_COLOR = "TextColor";
    public static final String USE_DESKTOP_FONT = "UseDesktopFont";
    public static final String RELOAD_FILES = "ReloadFiles";
    public static final String SAVE_WINDOWPOS = "SaveWindowPos";
    public static final String DATATIPS = "EnableDataTips";
    public static final String SYNTAX_COLOR = "Syncolor";
    public static final String GENERAL = "General";
    public static final String ECHO_ON = "EchoOn";
    public static final String NUMERIC_FORMAT = "NumFormat2";
    public static final String NUMERIC_DISPLAY = "NumDisplay";
    public static final String EIGHTY_COLUMNS = "EightyColumns";
    public static final String SHOW_TOOLTIPS = "ShowTooltips";
    public static final String USE_TOOLBOX_CACHE = "UseToolboxCache";
    public static final String USE_TOOLBOX_CACHE_DIAG = "UseToolboxCacheDiag";
    public static final String USE_PCODE_CACHE = "UsePCodeCache";
    public static final String PRINTING = "General";
    public static final String USE_DEFAULT_COLORS = "UseDefaultColors";
    public static final String USE_BLACK_AND_WHITE = "UseBlackAndWhite";
    public static final String ARRAY_EDITOR = "ArrayEditor";
    public static final String FONT = "Font";
    public static final String FORMAT = "Format";
    public static final String EXTERNAL = "External";
    public static final String DOCK_PATH = "DockPath";
    public static final String RETURN_MODE = "ReturnMode";
    public static final String INSPECTOR = "Inspector";
    public static final String WINDOW_BOUNDS = "WindowBounds";
    public static final String FILEBROWSER = "FileBrowser";
    public static final String SHOW_LAST_MODIFIED = "ShowLastModifiedDates";
    public static final String SHOW_DESCRIPTIONS = "ShowDescriptions";
    public static final String SHOW_COMMENT_BLOCK = "ShowCommentBlock";
    public static final String ALWAYS_SHOW_CWD = "AlwaysShowCWD";
    public static final String FILTER = "Filter";
    public static final String FIVE_COLUMN_WIDTHS = "FiveColumnWidths";
    public static final String HELP = "Help";
    public static final String ICEVERSION = "IceBrowserVersion_R13";
    public static final String DOCROOT = "DocRoot";
    public static final String SOURCE_TYPE = "DocSourceType";
    public static final String LOCAL_DIR = "LocalDirectory_R13";
    public static final String CDROM_DIR = "CDROMDirectory";
    public static final String PDF_READER = "PDF_Reader";
    public static final String HTML_BROWSER_FIXED_FONT = "HTML_Browser_FixedFont_R13";
    public static final String HTML_BROWSER_PROP_FONT = "HTML_Browser_ProportionalFont_R13";
    public static final String AUTOSYNC_CONTENTS = "AutosyncContents";
    public static final String NAVIGATOR_FONT = "NavigatorFont";
    public static final String SELECTED_PRODUCTS = "SelectedProducts";
    public static final String INDEX_SHOWALLPRODUCTS = "IndexShowAllProducts";
    public static final String SEARCH_SHOWALLPRODUCTS = "SearchShowAllProducts";
    public static final String FORWARD_TAB = "ForwardTab";
    public static final String SHOW_NAVIGATOR = "ShowNavigator";
    public static final String WORKSPACEBROWSER = "WorkspaceBrowser";
    public static final String SORT_COLUMN = "SortColumn";
    public static final String SORT_ASCENDING = "SortAscending";
    public static final String CLEAR_CONFIRM = "ClearConfirmation";
    public static final String ALLOW_EDIT = "AllowEditing";
    public static final String EDIT_LIMIT = "EditLimit";
    public static final String ALLOW_EXPAND = "AllowExpansion";
    public static final String EXPAND_LIMIT = "ExpansionLimit";
    private static final String sPropFileName = "matlab.prf";
    private static final String sPropFileHeader = "MATLAB Preferences";
    private static Prefs sPreferences;
    static final FontString sDefaultFontStr;
    private static final RectString sDefaultRectStr;
    private static SavePrefsThread sSavePrefsThread;
    private PrefsProperties fPrefs = new PrefsProperties();
    private Vector fListeners = new Vector();
    private boolean fDirty;
    private static String sPreviousDirectory;
    private static boolean sFirstPropDirRequest;
    static ResourceBundle sRes;
    private static byte[] hexDigit;
    private static byte[] BOOLEAN_TRUE;
    private static byte[] BOOLEAN_FALSE;
    private static byte[] sBuf21;

    private static native String nativeGetPreferencesDirectory();

    private static native String nativeGetPreviousPreferencesDirectory();

    private static native String nativeGetTimestampFileName();

    public static String getPropertyDirectory() {
        String string = Prefs.nativeGetPreferencesDirectory();
        if (string == null) {
            if (sFirstPropDirRequest) {
                System.err.println(sRes.getString("NoPreferenceDirectory"));
                sFirstPropDirRequest = false;
            }
        } else {
            File file = new File(string);
            if (!file.exists()) {
                file.mkdirs();
            }
        }
        return string;
    }

    public static synchronized String getPreviousPropertyDirectory() {
        if (sPreviousDirectory != null && sPreviousDirectory.equals("0") && (sPreviousDirectory = Prefs.nativeGetPreviousPreferencesDirectory()) != null) {
            File file = new File(Prefs.nativeGetPreferencesDirectory() + System.getProperty("file.separator") + Prefs.nativeGetTimestampFileName());
            if (file.exists() && file.isFile()) {
                file.delete();
            } else {
                sPreviousDirectory = null;
            }
        }
        return sPreviousDirectory;
    }

    public static String getPropertyFileName() {
        return sPropFileName;
    }

    public static String getPropertyFileHeader() {
        return sPropFileHeader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void load() {
        Prefs.sPreferences.fPrefs.clear();
        FileInputStream fileInputStream = null;
        try {
            File file = new File(Prefs.getPropertyDirectory(), sPropFileName);
            if (file.exists() && file.isFile()) {
                fileInputStream = new FileInputStream(file);
                sPreferences.loadPrefs(fileInputStream);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save() {
        File file = new File(Prefs.getPropertyDirectory(), sPropFileName);
        if (!Prefs.sPreferences.fDirty) {
            return;
        }
        if (!file.canWrite()) {
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                System.out.println(MessageFormat.format(sRes.getString("ReadOnlyPrefFile"), sPropFileName, Prefs.getPropertyDirectory()));
                return;
            }
        }
        if (!file.canWrite()) {
            System.out.println(MessageFormat.format(sRes.getString("ReadOnlyPrefFile"), sPropFileName, Prefs.getPropertyDirectory()));
            return;
        }
        SavePrefsThread savePrefsThread = sSavePrefsThread;
        synchronized (savePrefsThread) {
            String string = System.getProperties().getProperty("user.name");
            if (string != null && string.equals("batserve")) {
                return;
            }
            FileOutputStream fileOutputStream = null;
            Throwable throwable = null;
            for (int i = 0; i < 3; ++i) {
                throwable = null;
                try {
                    fileOutputStream = new FileOutputStream(file);
                    sPreferences.savePrefs(fileOutputStream, sPropFileHeader);
                }
                catch (Exception exception) {
                    throwable = exception;
                }
                finally {
                    if (fileOutputStream != null) {
                        try {
                            fileOutputStream.close();
                        }
                        catch (Exception exception) {
                            throwable = exception;
                        }
                    }
                }
                if (throwable == null) {
                    Prefs.sPreferences.fDirty = false;
                    break;
                }
                try {
                    Thread.sleep((int)(Math.random() * 2000.0) + 1000);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (throwable != null) {
                throwable.printStackTrace();
            }
        }
    }

    public static boolean exists(String string) {
        return Prefs.sPreferences.fPrefs.containsKey(string);
    }

    public static void remove(String string) {
        if (Prefs.sPreferences.fPrefs.containsKey(string)) {
            Prefs.sPreferences.fPrefs.remove(string);
        }
        Prefs.setAsDirty();
    }

    public static boolean getBooleanPref(String string) {
        return Prefs.getBooleanPref(string, false);
    }

    public static double getDoublePref(String string) {
        return Prefs.getDoublePref(string, 0.0);
    }

    public static int getIntegerPref(String string) {
        return Prefs.getIntegerPref(string, 0);
    }

    public static String getStringPref(String string) {
        return Prefs.getStringPref(string, "");
    }

    public static int getRGBColorPref(String string) {
        return Prefs.getRGBColorPref(string, Color.black.getRGB());
    }

    public static FontString getFontStringPref(String string) {
        return Prefs.getFontStringPref(string, sDefaultFontStr);
    }

    public static RectString getRectStringPref(String string) {
        return Prefs.getRectStringPref(string, sDefaultRectStr);
    }

    public static Color getColorPref(String string) {
        return PrefsAWT.getColorPref(string);
    }

    public static Font getFontPref(String string) {
        return PrefsAWT.getFontPref(string);
    }

    public static Rectangle getRectanglePref(String string) {
        return PrefsAWT.getRectanglePref(string);
    }

    public static boolean getBooleanPref(String string, boolean bl) {
        Object object = Prefs.sPreferences.fPrefs.get(string);
        if (object == null || !(object instanceof Boolean)) {
            return bl;
        }
        return (Boolean)object;
    }

    public static double getDoublePref(String string, double d) {
        Object object = Prefs.sPreferences.fPrefs.get(string);
        if (object == null || !(object instanceof Long)) {
            return d;
        }
        return Double.longBitsToDouble((Long)object);
    }

    public static int getIntegerPref(String string, int n) {
        Object object = Prefs.sPreferences.fPrefs.get(string);
        if (object == null || !(object instanceof Integer)) {
            return n;
        }
        return (Integer)object;
    }

    public static String getStringPref(String string, String string2) {
        Object object = Prefs.sPreferences.fPrefs.get(string);
        if (object == null || !(object instanceof String)) {
            return string2;
        }
        return (String)object;
    }

    public static int getRGBColorPref(String string, int n) {
        Object object = Prefs.sPreferences.fPrefs.get(string);
        if (object == null || !(object instanceof RGBInteger)) {
            return n;
        }
        return ((RGBInteger)object).intValue();
    }

    public static FontString getFontStringPref(String string, FontString fontString) {
        Object object = Prefs.sPreferences.fPrefs.get(string);
        if (object == null || !(object instanceof FontString)) {
            if (fontString == null) {
                fontString = sDefaultFontStr;
            }
            return fontString;
        }
        return (FontString)object;
    }

    public static RectString getRectStringPref(String string, RectString rectString) {
        Object object = Prefs.sPreferences.fPrefs.get(string);
        if (object == null || !(object instanceof RectString)) {
            if (rectString == null) {
                rectString = sDefaultRectStr;
            }
            return rectString;
        }
        return (RectString)object;
    }

    public static Color getColorPref(String string, Color color) {
        return PrefsAWT.getColorPref(string, color);
    }

    public static Font getFontPref(String string, Font font) {
        return PrefsAWT.getFontPref(string, font);
    }

    public static Rectangle getRectanglePref(String string, Rectangle rectangle) {
        return PrefsAWT.getRectanglePref(string, rectangle);
    }

    public static void setBooleanPref(String string, boolean bl) {
        if (!Prefs.isKeyValid(string)) {
            return;
        }
        Object object = Prefs.sPreferences.fPrefs.get(string);
        if (object == null || !(object instanceof Boolean) || (Boolean)object != bl) {
            Prefs.remove(string);
            Prefs.sPreferences.fPrefs.put(string, (Object)bl);
            Prefs.notifyListeners(string);
            Prefs.setAsDirty();
        }
    }

    public static void setDoublePref(String string, double d) {
        if (!Prefs.isKeyValid(string)) {
            return;
        }
        Object object = Prefs.sPreferences.fPrefs.get(string);
        if (object == null || !(object instanceof Long) || (Long)object != Double.doubleToLongBits(d)) {
            Prefs.remove(string);
            Prefs.sPreferences.fPrefs.put(string, (Object)Double.doubleToLongBits(d));
            Prefs.notifyListeners(string);
            Prefs.setAsDirty();
        }
    }

    public static void setIntegerPref(String string, int n) {
        if (!Prefs.isKeyValid(string)) {
            return;
        }
        Object object = Prefs.sPreferences.fPrefs.get(string);
        if (object == null || !(object instanceof Integer) || (Integer)object != n) {
            Prefs.remove(string);
            Prefs.sPreferences.fPrefs.put(string, (Object)n);
            Prefs.notifyListeners(string);
            Prefs.setAsDirty();
        }
    }

    public static void setStringPref(String string, String string2) {
        if (!Prefs.isKeyValid(string)) {
            return;
        }
        Object object = Prefs.sPreferences.fPrefs.get(string);
        if (object == null || !(object instanceof String) || !object.equals(string2)) {
            Prefs.remove(string);
            Prefs.sPreferences.fPrefs.put(string, string2);
            Prefs.notifyListeners(string);
            Prefs.setAsDirty();
        }
    }

    public static void setRGBColorPref(String string, int n) {
        if (!Prefs.isKeyValid(string)) {
            return;
        }
        Object object = Prefs.sPreferences.fPrefs.get(string);
        if (object == null || !(object instanceof RGBInteger) || ((RGBInteger)object).intValue() != n) {
            Prefs.remove(string);
            Prefs.sPreferences.fPrefs.put(string, new RGBInteger(n));
            Prefs.notifyListeners(string);
            Prefs.setAsDirty();
        }
    }

    public static void setFontStringPref(String string, FontString fontString) {
        if (!Prefs.isKeyValid(string)) {
            return;
        }
        Object object = Prefs.sPreferences.fPrefs.get(string);
        if (object == null || !(object instanceof FontString) || !object.equals(fontString)) {
            Prefs.remove(string);
            Prefs.sPreferences.fPrefs.put(string, fontString);
            Prefs.notifyListeners(string);
            Prefs.setAsDirty();
        }
    }

    public static void setRectStringPref(String string, RectString rectString) {
        if (!Prefs.isKeyValid(string)) {
            return;
        }
        Object object = Prefs.sPreferences.fPrefs.get(string);
        if (object == null || !(object instanceof RectString) || !object.equals(rectString)) {
            Prefs.remove(string);
            Prefs.sPreferences.fPrefs.put(string, rectString);
            Prefs.notifyListeners(string);
            Prefs.setAsDirty();
        }
    }

    public static void setColorPref(String string, Color color) {
        PrefsAWT.setColorPref(string, color);
    }

    public static void setFontPref(String string, Font font) {
        PrefsAWT.setFontPref(string, font);
    }

    public static void setRectanglePref(String string, Rectangle rectangle) {
        PrefsAWT.setRectanglePref(string, rectangle);
    }

    public static void addListener(PrefListener prefListener, String string) {
        PrefChangeListener prefChangeListener = new PrefChangeListener(prefListener, string);
        Prefs.sPreferences.fListeners.addElement(prefChangeListener);
    }

    public static void removeListener(PrefListener prefListener, String string) {
        for (int i = 0; i < Prefs.sPreferences.fListeners.size(); ++i) {
            if (prefListener != ((PrefChangeListener)Prefs.sPreferences.fListeners.elementAt(i)).getListener() || string != ((PrefChangeListener)Prefs.sPreferences.fListeners.elementAt(i)).getString()) continue;
            Prefs.sPreferences.fListeners.removeElementAt(i);
            break;
        }
    }

    public static void removeListener(PrefListener prefListener) {
        for (int i = 0; i < Prefs.sPreferences.fListeners.size(); ++i) {
            if (prefListener != ((PrefChangeListener)Prefs.sPreferences.fListeners.elementAt(i)).getListener()) continue;
            Prefs.sPreferences.fListeners.removeElementAt(i);
            --i;
        }
    }

    private static void notifyListeners(String string) {
        for (int i = 0; i < Prefs.sPreferences.fListeners.size(); ++i) {
            String string2 = ((PrefChangeListener)Prefs.sPreferences.fListeners.elementAt(i)).getString();
            if (!string2.regionMatches(0, string, 0, string2.length())) continue;
            PrefEvent prefEvent = new PrefEvent(sPreferences, string2, 1);
            ((PrefChangeListener)Prefs.sPreferences.fListeners.elementAt(i)).getListener().prefChanged(prefEvent);
        }
    }

    private static void setAsDirty() {
        Prefs.startSavePrefsThread();
        Prefs.dirtyPrefs();
    }

    private static void dirtyPrefs() {
        Prefs.sPreferences.fDirty = true;
        if (sSavePrefsThread != null) {
            sSavePrefsThread.dirty();
        }
    }

    private static void startSavePrefsThread() {
        if (sSavePrefsThread == null) {
            sSavePrefsThread = new SavePrefsThread("Prefs Updater");
            sSavePrefsThread.start();
        }
    }

    private void savePrefs(OutputStream outputStream, String string) {
        try {
            if (string != null) {
                outputStream.write(35);
                Prefs.writeString(outputStream, string, 0);
                outputStream.write(10);
            }
            outputStream.write(35);
            Prefs.writeString(outputStream, new Date().toString(), 0);
            outputStream.write(10);
            Enumeration<Object> enumeration = this.fPrefs.keys();
            while (enumeration.hasMoreElements()) {
                int n;
                String string2 = (String)enumeration.nextElement();
                Prefs.writeString(outputStream, string2, 0);
                outputStream.write(61);
                Object object = this.fPrefs.get(string2);
                if (object instanceof Boolean) {
                    if (((Boolean)object).booleanValue()) {
                        outputStream.write(BOOLEAN_TRUE);
                    } else {
                        outputStream.write(BOOLEAN_FALSE);
                    }
                } else if (object instanceof String) {
                    Prefs.writeString(outputStream, (String)object, 83);
                } else if (object instanceof Integer) {
                    Prefs.writeInt(outputStream, (Integer)object, 73);
                } else if (object instanceof Long) {
                    Prefs.writeLong(outputStream, (Long)object, 74);
                } else if (object instanceof RGBInteger) {
                    Prefs.writeInt(outputStream, ((RGBInteger)object).intValue(), 67);
                } else if (object instanceof FontString) {
                    n = ((FontString)object).charAt(0) == 'F' ? 0 : 70;
                    Prefs.writeString(outputStream, ((FontString)object).toString(), n);
                } else if (object instanceof RectString) {
                    n = ((RectString)object).charAt(0) == 'R' ? 0 : 82;
                    Prefs.writeString(outputStream, ((RectString)object).toString(), n);
                }
                outputStream.write(10);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public synchronized void loadPrefs(InputStream inputStream) throws IOException {
        CharBuffer charBuffer = new CharBuffer(80, 80);
        int n = inputStream.read();
        block14: while (true) {
            int n2;
            switch (n) {
                case -1: {
                    return;
                }
                case 33: 
                case 35: {
                    while ((n = inputStream.read()) >= 0 && n != 10 && n != 13) {
                    }
                    continue block14;
                }
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    n = inputStream.read();
                    continue block14;
                }
            }
            charBuffer.setSize(0, false);
            for (n2 = 0; n >= 0 && n != 61 && n != 58 && n != 32 && n != 9 && n != 10 && n != 13 && n2 < 128; ++n2) {
                charBuffer.append((char)n);
                n = inputStream.read();
            }
            if (n2 == 128) {
                while ((n = inputStream.read()) >= 0 && n != 10 && n != 13) {
                }
                continue;
            }
            while (n == 32 || n == 9) {
                n = inputStream.read();
            }
            if (n == 61 || n == 58) {
                n = inputStream.read();
            }
            String string = charBuffer.toString();
            int n3 = n;
            n = inputStream.read();
            Object object = null;
            switch (n3) {
                case 66: {
                    n = Prefs.readValue(inputStream, charBuffer, n);
                    object = Prefs.parseBoolean(charBuffer.getRawBuf(), charBuffer.length());
                    break;
                }
                case 73: {
                    n = Prefs.readValue(inputStream, charBuffer, n);
                    object = Prefs.parseInt(charBuffer.getRawBuf(), charBuffer.length(), 10);
                    break;
                }
                case 67: {
                    n = Prefs.readValue(inputStream, charBuffer, n);
                    object = new RGBInteger(Prefs.parseInt(charBuffer.getRawBuf(), charBuffer.length(), 10));
                    break;
                }
                case 74: {
                    n = Prefs.readValue(inputStream, charBuffer, n);
                    object = Prefs.parseLong(charBuffer.getRawBuf(), charBuffer.length(), 10);
                    break;
                }
                case 70: {
                    n = Prefs.readString(inputStream, charBuffer, n, n3);
                    object = new FontString(charBuffer.toString());
                    break;
                }
                case 82: {
                    n = Prefs.readString(inputStream, charBuffer, n, n3);
                    object = new RectString(charBuffer.toString());
                    break;
                }
                case 83: {
                    n = Prefs.readString(inputStream, charBuffer, n, 0);
                    object = charBuffer.toString();
                }
            }
            if (object == null) continue;
            this.fPrefs.put(string, object);
        }
    }

    private static int readToken(InputStream inputStream, CharBuffer charBuffer, int n) throws IOException {
        while (n >= 0 && (n == 32 || n == 9)) {
            n = inputStream.read();
        }
        charBuffer.setSize(0, false);
        while (n >= 0 && n != 10 && n != 13 && n != 32 && n != 9) {
            charBuffer.append((char)n);
            n = inputStream.read();
        }
        return n;
    }

    private static int readValue(InputStream inputStream, CharBuffer charBuffer, int n) throws IOException {
        while (n >= 0 && (n == 32 || n == 9)) {
            n = inputStream.read();
        }
        charBuffer.setSize(0, false);
        while (n >= 0 && n != 10 && n != 13 && n != 32 && n != 9) {
            charBuffer.append((char)n);
            n = inputStream.read();
        }
        while (n >= 0 && n != 10 && n != 13) {
            n = inputStream.read();
        }
        return n;
    }

    static int readString(InputStream inputStream, CharBuffer charBuffer, int n, int n2) throws IOException {
        while (n >= 0 && (n == 32 || n == 9)) {
            n = inputStream.read();
        }
        charBuffer.setSize(0, false);
        if (n2 != 0) {
            charBuffer.append((char)n2);
        }
        block9: while (n >= 0 && n != 10 && n != 13) {
            int n3 = 0;
            if (n == 92) {
                n = inputStream.read();
                switch (n) {
                    case 13: {
                        n = inputStream.read();
                        if (n != 10 && n != 32 && n != 9) continue block9;
                    }
                    case 10: {
                        while ((n = inputStream.read()) == 32 || n == 9) {
                        }
                        continue block9;
                    }
                    case 116: {
                        n = 9;
                        n3 = inputStream.read();
                        break;
                    }
                    case 110: {
                        n = 10;
                        n3 = inputStream.read();
                        break;
                    }
                    case 114: {
                        n = 13;
                        n3 = inputStream.read();
                        break;
                    }
                    case 117: {
                        int n4 = 0;
                        while ((n = inputStream.read()) == 117) {
                        }
                        for (int i = 0; i < 4; ++i) {
                            n3 = inputStream.read();
                            if (n <= 57 && n >= 48) {
                                n4 = (n4 << 4) + n - 48;
                            } else if (n >= 97 && n <= 102) {
                                n4 = (n4 << 4) + 10 + n - 97;
                            } else {
                                if (n < 65 || n > 70) break;
                                n4 = (n4 << 4) + 10 + n - 65;
                            }
                            n = n3;
                        }
                        n = n4;
                        break;
                    }
                    default: {
                        n3 = inputStream.read();
                        break;
                    }
                }
            } else {
                n3 = inputStream.read();
            }
            charBuffer.append((char)n);
            n = n3;
        }
        return n;
    }

    static int parseInt(String string, int n, int n2, int n3) {
        n2 = Math.min(string.length(), n + n2);
        int n4 = 0;
        boolean bl = false;
        if (n2 > 0) {
            int n5;
            int n6;
            int n7;
            if (string.charAt(n) == '-') {
                n7 = n + 1;
                n6 = Integer.MIN_VALUE;
            } else {
                n7 = n;
                bl = true;
                n6 = -2147483647;
            }
            int n8 = n6 / n3;
            if (n7 < n2) {
                if ((n5 = Character.digit(string.charAt(n7++), n3)) < 0) {
                    n7 = n2;
                } else {
                    n4 = -n5;
                }
            }
            while (n7 < n2) {
                if ((n5 = Character.digit(string.charAt(n7++), n3)) < 0 || n4 < n8) {
                    n4 = 0;
                    break;
                }
                if ((n4 *= n3) < n6 + n5) {
                    n4 = 0;
                    break;
                }
                n4 -= n5;
            }
        }
        if (bl) {
            n4 = -n4;
        }
        return n4;
    }

    private static boolean parseBoolean(char[] cArray, int n) {
        return !(n != 4 || cArray[0] != 't' && cArray[0] != 'T' || cArray[1] != 'r' && cArray[1] != 'R' || cArray[2] != 'u' && cArray[2] != 'U' || cArray[3] != 'e' && cArray[3] != 'E');
    }

    private static int parseInt(char[] cArray, int n, int n2) {
        boolean bl = false;
        int n3 = 0;
        if (n > 0) {
            int n4;
            int n5;
            int n6 = 0;
            if (cArray[0] == '-') {
                n6 = 1;
                n5 = Integer.MIN_VALUE;
            } else {
                n6 = 0;
                bl = true;
                n5 = -2147483647;
            }
            int n7 = n5 / n2;
            if (n6 < n) {
                if ((n4 = Character.digit(cArray[n6++], n2)) < 0) {
                    n6 = n;
                } else {
                    n3 = -n4;
                }
            }
            while (n6 < n) {
                if ((n4 = Character.digit(cArray[n6++], n2)) < 0 || n3 < n7) {
                    n3 = 0;
                    break;
                }
                if ((n3 *= n2) < n5 + n4) {
                    n3 = 0;
                    break;
                }
                n3 -= n4;
            }
        }
        if (bl) {
            n3 = -n3;
        }
        return n3;
    }

    private static long parseLong(char[] cArray, int n, int n2) {
        boolean bl = false;
        long l = 0L;
        if (n > 0) {
            int n3;
            long l2;
            int n4 = 0;
            if (cArray[0] == '-') {
                n4 = 1;
                l2 = Long.MIN_VALUE;
            } else {
                n4 = 0;
                bl = true;
                l2 = -9223372036854775807L;
            }
            long l3 = l2 / (long)n2;
            if (n4 < n) {
                if ((n3 = Character.digit(cArray[n4++], n2)) < 0) {
                    n4 = n;
                } else {
                    l = -n3;
                }
            }
            while (n4 < n) {
                if ((n3 = Character.digit(cArray[n4++], n2)) < 0 || l < l3) {
                    l = 0L;
                    break;
                }
                if ((l *= (long)n2) < l2 + (long)n3) {
                    l = 0L;
                    break;
                }
                l -= (long)n3;
            }
        }
        if (bl) {
            l = -l;
        }
        return l;
    }

    private static void writeInt(OutputStream outputStream, int n, int n2) throws IOException {
        int n3;
        if (n2 != 0) {
            n3 = 1;
            Prefs.sBuf21[0] = (byte)n2;
        } else {
            n3 = 0;
        }
        n3 = Prefs.intToBytes(sBuf21, n3, n);
        outputStream.write(sBuf21, 0, n3);
    }

    private static void writeLong(OutputStream outputStream, long l, int n) throws IOException {
        int n2;
        if (n != 0) {
            n2 = 1;
            Prefs.sBuf21[0] = (byte)n;
        } else {
            n2 = 0;
        }
        n2 = Prefs.longToBytes(sBuf21, n2, l);
        outputStream.write(sBuf21, 0, n2);
    }

    private static boolean isKeyValid(String string) {
        boolean bl = true;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c >= ' ' && c < '\u007f') continue;
            System.err.println("Invalid preference key: " + string);
            Thread.dumpStack();
            bl = false;
        }
        return bl;
    }

    private static void writeString(OutputStream outputStream, String string, int n) throws IOException {
        int n2 = string.length();
        if (n != 0) {
            outputStream.write((byte)n);
        }
        block6: for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            if (c >= ' ' && c < '\u007f') {
                if (n != 0 && c == '\\') {
                    outputStream.write(92);
                }
                outputStream.write((byte)c);
                continue;
            }
            switch (c) {
                case '\\': {
                    outputStream.write(92);
                    outputStream.write(92);
                    continue block6;
                }
                case '\t': {
                    outputStream.write(92);
                    outputStream.write(116);
                    continue block6;
                }
                case '\n': {
                    outputStream.write(92);
                    outputStream.write(110);
                    continue block6;
                }
                case '\r': {
                    outputStream.write(92);
                    outputStream.write(114);
                    continue block6;
                }
                default: {
                    outputStream.write(92);
                    outputStream.write(117);
                    outputStream.write(hexDigit[c >> 12 & 0xF]);
                    outputStream.write(hexDigit[c >> 8 & 0xF]);
                    outputStream.write(hexDigit[c >> 4 & 0xF]);
                    outputStream.write(hexDigit[c & 0xF]);
                }
            }
        }
    }

    private static int intToBytes(byte[] byArray, int n, int n2) {
        int n3 = n;
        int n4 = n2 < 0 ? -n2 : n2;
        do {
            byArray[n3++] = (byte)(n4 % 10 + 48);
        } while ((n4 /= 10) > 0);
        if (n2 < 0) {
            byArray[n3++] = 45;
        }
        int n5 = n + (n3 - n >> 1);
        for (n4 = n; n4 < n5; ++n4) {
            int n6 = n3 - n4 + n - 1;
            byte by = byArray[n4];
            byArray[n4] = byArray[n6];
            byArray[n6] = by;
        }
        return n3;
    }

    private static int longToBytes(byte[] byArray, int n, long l) {
        int n2 = n;
        long l2 = l < 0L ? -l : l;
        do {
            byArray[n2++] = (byte)(l2 % 10L + 48L);
        } while ((l2 /= 10L) > 0L);
        if (l < 0L) {
            byArray[n2++] = 45;
        }
        int n3 = n + (n2 - n >> 1);
        for (int i = n; i < n3; ++i) {
            int n4 = n2 - i + n - 1;
            byte by = byArray[i];
            byArray[i] = byArray[n4];
            byArray[n4] = by;
        }
        return n2;
    }

    static {
        sDefaultFontStr = new FontString("F0 12 Dialog");
        sDefaultRectStr = new RectString("R0 0 0 0");
        sPreviousDirectory = "0";
        sFirstPropDirRequest = true;
        sRes = ResourceBundle.getBundle("com.mathworks.services.resources.RES_Services");
        try {
            System.loadLibrary("nativeservices");
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        sPreferences = new Prefs();
        Prefs.load();
        FileUtils.setPreferencesDirectory((String)Prefs.getPropertyDirectory());
        hexDigit = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};
        BOOLEAN_TRUE = new byte[]{66, 116, 114, 117, 101};
        BOOLEAN_FALSE = new byte[]{66, 102, 97, 108, 115, 101};
        sBuf21 = new byte[21];
    }

    static final class RectString
    extends PrefString {
        public RectString(String string) {
            super(string);
        }
    }

    static final class FontString
    extends PrefString {
        public FontString(String string) {
            super(string);
        }
    }

    private static class PrefString {
        String fData;

        public PrefString(String string) {
            this.fData = string;
        }

        public char charAt(int n) {
            return this.fData.charAt(n);
        }

        public boolean equals(Object object) {
            return this.fData.equals(object);
        }

        public int length() {
            return this.fData.length();
        }

        public int hashCode() {
            return this.fData.hashCode();
        }

        public String toString() {
            return this.fData;
        }
    }

    private static class PrefsProperties
    extends Properties {
        private PrefsProperties() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object put(Object object, Object object2) {
            if (sSavePrefsThread != null) {
                SavePrefsThread savePrefsThread = sSavePrefsThread;
                synchronized (savePrefsThread) {
                    return super.put(object, object2);
                }
            }
            return super.put(object, object2);
        }
    }

    private static class SavePrefsThread
    extends Thread {
        long fDirtyTime = Long.MAX_VALUE;

        SavePrefsThread(String string) {
            super(string);
            this.setPriority(1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void dirty() {
            SavePrefsThread savePrefsThread = this;
            synchronized (savePrefsThread) {
                this.fDirtyTime = System.currentTimeMillis() + 100L;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                try {
                    SavePrefsThread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                SavePrefsThread savePrefsThread = this;
                synchronized (savePrefsThread) {
                    if (System.currentTimeMillis() > this.fDirtyTime) {
                        this.fDirtyTime = Long.MAX_VALUE;
                        Prefs.save();
                    }
                }
            }
        }
    }
}

