/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.services;

import com.mathworks.services.Browseable;
import com.mathworks.services.BrowseableEvent;
import com.mathworks.services.BrowseableListener;
import com.mathworks.services.BrowseableTreeAction;
import com.mathworks.services.BrowseableUtils;
import com.mathworks.services.ObjRegBrowseableEvent;
import com.mathworks.services.ObjectOwner;
import com.mathworks.services.ObjectRegistryEntry;
import com.mathworks.services.ObjectRegistryEntryRoot;
import com.mathworks.services.ObjectRegistryEvent;
import com.mathworks.services.ObjectRegistryListener;
import java.awt.AWTEventMulticaster;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;

public class ObjectRegistry
implements ItemSelectable {
    public static final int AT_END = -1;
    public static final int NO_TRANSACTION = -1;
    private static final int INTERNAL_TRANSACTION = -2;
    private static ObjectRegistry sRegistry = null;
    private static ObjectRegistry sLayoutRegistry = null;
    private static Browseable sMatlabRegistry = null;
    private static Browseable sGuideRegistry = null;
    private ObjectRegistryEntry fRegistry = new ObjectRegistryEntry(this, null, true);
    private BrowseableListener fEntryListener = new MyBrowseableHandler();
    private Vector fObjectRegistryListeners;
    private Vector fSelection;
    private ItemListener fItemListener;
    private int fUniqueTransactionID;
    private boolean fUseStaticEntries;

    public ObjectRegistry() {
        this.fRegistry.addBrowseableListener(this.fEntryListener);
        this.fSelection = new Vector();
        this.fObjectRegistryListeners = new Vector();
        this.fItemListener = null;
        this.fUniqueTransactionID = 0;
    }

    public Browseable getBrowseable() {
        return this.fRegistry;
    }

    public synchronized int beginTransaction() {
        int n = this.fUniqueTransactionID++;
        this.fireObjectRegistryEvent(new ObjectRegistryEvent(this, 4, n));
        return n;
    }

    public synchronized void endTransaction(int n) {
        this.fireObjectRegistryEvent(new ObjectRegistryEvent(this, 5, n));
    }

    public synchronized void register(Object object, Object object2) {
        Object[] objectArray = new Object[]{object};
        this.register(objectArray, object2, -1, (ObjectOwner)null, false, -1);
    }

    public synchronized void register(Object object, Object object2, int n, ObjectOwner objectOwner, boolean bl) {
        Object[] objectArray = new Object[]{object};
        this.register(objectArray, object2, n, objectOwner, bl, -1);
    }

    public synchronized void register(Object object, Object object2, int n, ObjectOwner objectOwner, boolean bl, int n2) {
        Object[] objectArray = new Object[]{object};
        this.register(objectArray, object2, n, objectOwner, bl, n2);
    }

    public synchronized void register(Object[] objectArray, Object object, int n, ObjectOwner objectOwner, boolean bl) {
        this.register(objectArray, object, n, objectOwner, bl, -1);
    }

    public synchronized void register(Object[] objectArray, Object object, int n, ObjectOwner objectOwner, boolean bl, int n2) {
        ObjectRegistryEntry objectRegistryEntry;
        if (objectArray != null && objectArray.length > 0 && (objectRegistryEntry = this.getEntry(object)) != null) {
            Browseable[] browseableArray = new Browseable[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                browseableArray[i] = this.fUseStaticEntries ? ObjectRegistryEntry.newStaticEntry(objectArray[i], objectOwner, bl) : ObjectRegistryEntry.newEntry(objectArray[i], objectOwner, bl);
            }
            if (n == -1) {
                objectRegistryEntry.addChildren(browseableArray, n2);
            } else {
                objectRegistryEntry.insertChildren(browseableArray, n, n2);
            }
        }
    }

    public synchronized void unregister(Object object) {
        Object[] objectArray = new Object[]{object};
        this.unregister(objectArray, -1);
    }

    public synchronized void unregister(Object[] objectArray) {
        this.unregister(objectArray, -1);
    }

    private synchronized void unregister(Object object, int n) {
        Object[] objectArray = new Object[]{object};
        this.unregister(objectArray, n);
    }

    private synchronized void unregister(Object[] objectArray, int n) {
        if (objectArray != null && objectArray.length > 0) {
            boolean bl = n == -1;
            int n2 = n;
            if (bl) {
                n2 = this.beginTransaction();
            }
            for (int i = 0; i < objectArray.length; ++i) {
                Browseable browseable;
                ObjectRegistryEntry objectRegistryEntry = this.getEntry(objectArray[i]);
                if (objectRegistryEntry instanceof ObjectRegistryEntry) {
                    this.unregisterChildren(objectArray[i], n2);
                }
                if (objectRegistryEntry == null || !((browseable = objectRegistryEntry.browseableParent()) instanceof ObjectRegistryEntry)) continue;
                ((ObjectRegistryEntry)browseable).removeChild(objectRegistryEntry, n2);
            }
            if (bl) {
                this.endTransaction(n2);
            }
        }
    }

    public synchronized void unregisterChildren(Object object) {
        this.unregisterChildren(object, -1);
    }

    public synchronized void unregisterChildren(Object object, int n) {
        this.unregister(this.getChildrenAsArray(object), n);
    }

    public void change(Object[] objectArray) {
        this.change(objectArray, null, -1);
    }

    public void change(Object[] objectArray, int n) {
        this.change(objectArray, null, n);
    }

    public void change(Object[] objectArray, Object object) {
        this.change(objectArray, object, -1);
    }

    public void change(Object[] objectArray, Object object, int n) {
        for (int i = 0; i < objectArray.length; ++i) {
            ObjectRegistryEntry objectRegistryEntry = this.getEntry(objectArray[i]);
            if (objectRegistryEntry != null && objectRegistryEntry.browseableParent() instanceof ObjectRegistryEntry) {
                ObjectRegistryEntry objectRegistryEntry2 = (ObjectRegistryEntry)objectRegistryEntry.browseableParent();
                objectRegistryEntry2.changeChild(objectRegistryEntry, n, object);
                continue;
            }
            if (objectRegistryEntry != null) continue;
            this.fireObjectRegistryEvent(new ObjectRegistryEvent(this, 2, objectArray, null, -1, object, n));
        }
    }

    public void move(Object[] objectArray, Object object, int n) {
        this.move(objectArray, object, n, -1);
    }

    public void move(Object[] objectArray, Object object, int n, int n2) {
        if (objectArray != null && objectArray.length > 0) {
            ObjectRegistryEntry objectRegistryEntry = this.getEntry(object);
            boolean bl = n2 == -1;
            int n3 = n2;
            if (objectRegistryEntry != null) {
                if (bl) {
                    n3 = this.beginTransaction();
                }
                Browseable[] browseableArray = new Browseable[objectArray.length];
                for (int i = 0; i < objectArray.length; ++i) {
                    Browseable browseable;
                    browseableArray[i] = this.getEntry(objectArray[i]);
                    if (browseableArray[i] == null || !((browseable = browseableArray[i].browseableParent()) instanceof ObjectRegistryEntry)) continue;
                    ((ObjectRegistryEntry)browseable).removeChild(browseableArray[i], n3);
                }
                if (n == -1) {
                    objectRegistryEntry.addChildren(browseableArray, n3);
                } else {
                    objectRegistryEntry.insertChildren(browseableArray, n, n3);
                }
                if (bl) {
                    this.endTransaction(n3);
                }
            }
        }
    }

    public Vector getTopLevelObjects() {
        Vector<Object> vector = new Vector<Object>();
        if (this.fRegistry.browseableChildCount() > 0) {
            for (Browseable browseable = this.fRegistry.browseableChild(0); browseable != null; browseable = browseable.browseableNextSibling()) {
                vector.addElement(browseable.browseableDataObject());
            }
        }
        return vector;
    }

    public boolean isParental(Object object) {
        boolean bl = false;
        ObjectRegistryEntry objectRegistryEntry = this.getEntry(object);
        if (objectRegistryEntry != null) {
            bl = objectRegistryEntry.browseableCanHaveChildren();
        } else if (object instanceof Browseable) {
            bl = ((Browseable)object).browseableCanHaveChildren();
        }
        return bl;
    }

    public Object[] getChildrenAsArray(Object object) {
        Vector vector = this.getChildren(object);
        Object[] objectArray = new Object[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public Vector getChildren(Object object) {
        Vector<Object> vector = new Vector<Object>();
        Browseable browseable = this.getEntry(object);
        if (browseable == null && object instanceof Browseable) {
            browseable = (Browseable)object;
        }
        if (browseable != null && browseable.browseableChildCount() > 0) {
            for (Browseable browseable2 = browseable.browseableChild(0); browseable2 != null; browseable2 = browseable2.browseableNextSibling()) {
                vector.addElement(browseable2.browseableDataObject());
            }
        }
        return vector;
    }

    public Object getParent(Object object) {
        Object object2 = null;
        Browseable browseable = this.getEntry(object);
        if (browseable == null && object instanceof Browseable) {
            browseable = (Browseable)object;
        }
        if (browseable != null && browseable.browseableParent() != null && browseable.browseableParent() != this.fRegistry) {
            object2 = browseable.browseableParent().browseableDataObject();
        }
        return object2;
    }

    public ObjectOwner getOwner(Object object) {
        ObjectOwner objectOwner = null;
        ObjectRegistryEntry objectRegistryEntry = this.getEntry(object);
        if (objectRegistryEntry != null) {
            objectOwner = objectRegistryEntry.getOwner();
        }
        return objectOwner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSelected(Object object) {
        Vector vector = this.fSelection;
        synchronized (vector) {
            return this.fSelection.contains(object);
        }
    }

    public void setSelected(Object[] objectArray, boolean bl) {
        this.setSelected(objectArray, bl, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelected(Object[] objectArray, boolean bl, boolean bl2) {
        Vector<Object> vector = new Vector<Object>();
        Vector<Object> vector2 = new Vector<Object>();
        Object[] objectArray2 = this.fSelection;
        synchronized (objectArray2) {
            int n;
            if (bl2) {
                for (n = 0; n < this.fSelection.size(); ++n) {
                    vector2.addElement(this.fSelection.elementAt(n));
                    this.fireOwnerSelection(this.fSelection.elementAt(n), false);
                }
                this.fSelection.removeAllElements();
                if (bl) {
                    for (n = 0; n < objectArray.length; ++n) {
                        if (objectArray[n] == null) continue;
                        this.fSelection.addElement(objectArray[n]);
                        vector.addElement(objectArray[n]);
                        this.fireOwnerSelection(objectArray[n], true);
                    }
                }
            } else {
                for (n = 0; n < objectArray.length; ++n) {
                    if (bl && objectArray[n] != null && !this.fSelection.contains(objectArray[n])) {
                        this.fSelection.addElement(objectArray[n]);
                        vector.addElement(objectArray[n]);
                        this.fireOwnerSelection(objectArray[n], true);
                        continue;
                    }
                    if (bl || objectArray[n] == null || !this.fSelection.contains(objectArray[n])) continue;
                    this.fSelection.removeElement(objectArray[n]);
                    vector2.addElement(objectArray[n]);
                    this.fireOwnerSelection(objectArray[n], false);
                }
            }
        }
        if (vector2.size() > 0 && vector.size() > 0) {
            objectArray2 = vector.elements();
            while (objectArray2.hasMoreElements()) {
                Object e = objectArray2.nextElement();
                if (!vector2.contains(e)) continue;
                vector2.removeElement(e);
            }
        }
        if (vector2.size() > 0) {
            objectArray2 = new Object[vector2.size()];
            vector2.copyInto(objectArray2);
            this.fireItemEvent(new ItemEvent(this, 701, objectArray2, 2));
        }
        if (vector.size() > 0) {
            objectArray2 = new Object[vector.size()];
            vector.copyInto(objectArray2);
            this.fireItemEvent(new ItemEvent(this, 701, objectArray2, 1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getSelectedObjects() {
        Vector vector = this.fSelection;
        synchronized (vector) {
            Object[] objectArray = new Object[this.fSelection.size()];
            this.fSelection.copyInto(objectArray);
            return objectArray;
        }
    }

    public void addItemListener(ItemListener itemListener) {
        this.fItemListener = AWTEventMulticaster.add(this.fItemListener, itemListener);
    }

    public void removeItemListener(ItemListener itemListener) {
        this.fItemListener = AWTEventMulticaster.remove(this.fItemListener, itemListener);
    }

    public synchronized void addObjectRegistryListener(ObjectRegistryListener objectRegistryListener) {
        if (!this.fObjectRegistryListeners.contains(objectRegistryListener)) {
            this.fObjectRegistryListeners.addElement(objectRegistryListener);
        }
    }

    public synchronized void removeObjectRegistryListener(ObjectRegistryListener objectRegistryListener) {
        if (this.fObjectRegistryListeners.contains(objectRegistryListener)) {
            // empty if block
        }
        this.fObjectRegistryListeners.removeElement(objectRegistryListener);
    }

    private final void fireOwnerSelection(Object object, boolean bl) {
        ObjectRegistryEntry objectRegistryEntry = this.getEntry(object);
        if (objectRegistryEntry != null) {
            ObjectOwner objectOwner = objectRegistryEntry.getOwner();
            Object[] objectArray = new Object[]{object};
            if (objectOwner != null) {
                objectOwner.setSelected(objectArray, bl);
            }
        }
    }

    public void fireItemEvent(ItemEvent itemEvent) {
        if (this.fItemListener != null) {
            this.fItemListener.itemStateChanged(itemEvent);
        }
    }

    private void fireObjectRegistryEvent(ObjectRegistryEvent objectRegistryEvent) {
        Vector vector = (Vector)this.fObjectRegistryListeners.clone();
        block8: for (int i = 0; i < vector.size(); ++i) {
            ObjectRegistryListener objectRegistryListener = (ObjectRegistryListener)vector.elementAt(i);
            switch (objectRegistryEvent.getEventType()) {
                case 0: {
                    objectRegistryListener.objectRegistered(objectRegistryEvent);
                    continue block8;
                }
                case 1: {
                    objectRegistryListener.objectUnregistered(objectRegistryEvent);
                    continue block8;
                }
                case 2: {
                    objectRegistryListener.objectChanged(objectRegistryEvent);
                    continue block8;
                }
                case 3: {
                    objectRegistryListener.objectMoved(objectRegistryEvent);
                    continue block8;
                }
                case 4: {
                    objectRegistryListener.transactionStarted(objectRegistryEvent);
                    continue block8;
                }
                case 5: {
                    objectRegistryListener.transactionEnded(objectRegistryEvent);
                }
            }
        }
    }

    private final ObjectRegistryEntry registerRootEntry(String string) {
        ObjectRegistryEntryRoot objectRegistryEntryRoot = new ObjectRegistryEntryRoot(string);
        this.fRegistry.addChild(objectRegistryEntryRoot, -1);
        return objectRegistryEntryRoot;
    }

    private final ObjectRegistryEntry getEntry(Object object) {
        ObjectRegistryEntry objectRegistryEntry = this.fRegistry;
        if (object != null) {
            objectRegistryEntry = this.findStaticObject(object);
        }
        return objectRegistryEntry;
    }

    private final ObjectRegistryEntry findStaticObject(Object object) {
        ObjectRegistryEntry objectRegistryEntry = null;
        if (object != null) {
            FindStaticObjectAction findStaticObjectAction = new FindStaticObjectAction(object);
            BrowseableUtils.walkTree(this.fRegistry, findStaticObjectAction);
            objectRegistryEntry = findStaticObjectAction.getResult();
        }
        return objectRegistryEntry;
    }

    public static Browseable getFullRegistry() {
        return sRegistry.getBrowseable();
    }

    public static Browseable getMatlabRegistry() {
        return sMatlabRegistry;
    }

    public static Browseable getGuideRegistry() {
        return sGuideRegistry;
    }

    public static ObjectRegistry getRegistry() {
        return sRegistry;
    }

    public static ObjectRegistry getLayoutRegistry() {
        return sLayoutRegistry;
    }

    static {
        sRegistry = new ObjectRegistry();
        sLayoutRegistry = new ObjectRegistry();
        ObjectRegistry.sLayoutRegistry.fUseStaticEntries = true;
    }

    private class MyBrowseableHandler
    implements BrowseableListener {
        private MyBrowseableHandler() {
        }

        public void childAdded(BrowseableEvent browseableEvent) {
            Object object = browseableEvent.getSource().browseableDataObject();
            Browseable[] browseableArray = browseableEvent.getItems();
            if (browseableEvent.getSource() == ObjectRegistry.this.fRegistry) {
                object = null;
            }
            if (browseableArray != null) {
                for (int i = 0; i < browseableArray.length; ++i) {
                    if (browseableArray[i] == null) continue;
                    browseableArray[i].addBrowseableListener(this);
                }
            }
            ObjectRegistry.this.fireObjectRegistryEvent(new ObjectRegistryEvent(ObjectRegistry.this, 0, this.mapItems(browseableEvent.getItems()), object, browseableEvent.getPosition(), browseableEvent.getTransactionID()));
        }

        public void childRemoved(BrowseableEvent browseableEvent) {
            Object[] objectArray = new Object[]{browseableEvent.getSource().browseableDataObject()};
            Browseable[] browseableArray = browseableEvent.getItems();
            if (browseableArray != null) {
                for (int i = 0; i < browseableArray.length; ++i) {
                    if (browseableArray[i] == null) continue;
                    browseableArray[i].removeBrowseableListener(this);
                }
            }
            ObjectRegistry.this.fireObjectRegistryEvent(new ObjectRegistryEvent(ObjectRegistry.this, 1, this.mapItems(browseableEvent.getItems()), objectArray, null, -1, browseableEvent.getTransactionID()));
        }

        public void childChanged(BrowseableEvent browseableEvent) {
            if (browseableEvent instanceof ObjRegBrowseableEvent) {
                Object object = ((ObjRegBrowseableEvent)browseableEvent).getChangeSource();
                ObjectRegistry.this.fireObjectRegistryEvent(new ObjectRegistryEvent(ObjectRegistry.this, 2, this.mapItems(browseableEvent.getItems()), null, -1, object, browseableEvent.getTransactionID()));
            } else {
                ObjectRegistry.this.fireObjectRegistryEvent(new ObjectRegistryEvent(ObjectRegistry.this, 2, this.mapItems(browseableEvent.getItems()), null, -1, null, browseableEvent.getTransactionID()));
            }
        }

        public void transactionStarted(BrowseableEvent browseableEvent) {
            ObjectRegistry.this.fireObjectRegistryEvent(new ObjectRegistryEvent(ObjectRegistry.this, 4, browseableEvent.getTransactionID()));
        }

        public void transactionEnded(BrowseableEvent browseableEvent) {
            ObjectRegistry.this.fireObjectRegistryEvent(new ObjectRegistryEvent(ObjectRegistry.this, 5, browseableEvent.getTransactionID()));
        }

        private Object[] mapItems(Browseable[] browseableArray) {
            Object[] objectArray = new Object[]{};
            if (browseableArray != null) {
                objectArray = new Object[browseableArray.length];
                for (int i = 0; i < objectArray.length; ++i) {
                    objectArray[i] = browseableArray[i].browseableDataObject();
                }
            }
            return objectArray;
        }
    }

    private class FindStaticObjectAction
    implements BrowseableTreeAction {
        private Object fObjectToFind;
        private ObjectRegistryEntry fResult;

        FindStaticObjectAction(Object object) {
            this.fObjectToFind = object;
            this.fResult = null;
        }

        public int performAction(Browseable browseable) {
            int n = 0;
            if (browseable instanceof ObjectRegistryEntry) {
                if (this.fObjectToFind == browseable.browseableDataObject()) {
                    n = 1;
                    this.fResult = (ObjectRegistryEntry)browseable;
                }
            } else {
                n = 2;
            }
            return n;
        }

        ObjectRegistryEntry getResult() {
            return this.fResult;
        }
    }
}

