/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.services;

import com.mathworks.mwswing.FontUtils;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.services.FontListener;
import com.mathworks.services.Prefs;
import com.mathworks.services.PrefsAWT;
import com.mathworks.util.PlatformInfo;
import java.awt.Font;
import java.awt.Toolkit;
import java.lang.reflect.Method;
import java.util.Vector;
import javax.swing.SwingUtilities;

public final class FontPrefs {
    public static final String CODE_FONT = "CodeFont";
    public static final String TEXT_FONT = "TextFont";
    public static final String CUSTOM_FONT = "CustomFont";
    private static final float JAVA_DPI = 72.0f;
    private static final float ACTUAL_DPI = Toolkit.getDefaultToolkit().getScreenResolution();
    public static final Font DEFAULT_CODE_FONT;
    public static final Font DEFAULT_TEXT_FONT;
    public static final Font DEFAULT_CUSTOM_FONT;
    public static final String USE_SYSTEM_FONT = "TextUseSystemFont";
    private static Font sCodeFont;
    private static Font sTextFont;
    private static boolean sTextUseSystemFont;
    private static Vector sComponents;
    private static Vector sFontListeners;

    private FontPrefs() {
    }

    public static Font convertJavaToPointFont(Font font) {
        float f = (float)font.getSize() * (72.0f / ACTUAL_DPI);
        return font.deriveFont(f);
    }

    public static Font convertPointToJavaFont(Font font) {
        float f = (float)font.getSize() * (ACTUAL_DPI / 72.0f);
        return font.deriveFont(f);
    }

    public static void addFontListener(String string, FontListener fontListener) {
        boolean bl = false;
        for (int i = 0; i < sComponents.size(); ++i) {
            FontItem fontItem = (FontItem)sComponents.elementAt(i);
            if (!fontItem.getComponentName().equals(string)) continue;
            fontItem.addFontListener(fontListener);
            bl = true;
            break;
        }
        if (!bl) {
            System.out.println("FontPrefs: unable to find font for component " + string);
        }
    }

    public static void removeFontListener(String string, FontListener fontListener) {
        for (int i = 0; i < sComponents.size(); ++i) {
            FontItem fontItem = (FontItem)sComponents.elementAt(i);
            if (!fontItem.getComponentName().equals(string)) continue;
            fontItem.removeFontListener(fontListener);
            break;
        }
    }

    public static Font getFontForComponent(String string) {
        for (int i = 0; i < sComponents.size(); ++i) {
            FontItem fontItem = (FontItem)sComponents.elementAt(i);
            if (!fontItem.getComponentName().equals(string)) continue;
            if (fontItem.getFontType().equals(TEXT_FONT)) {
                return FontPrefs.getTextFont();
            }
            if (fontItem.getFontType().equals(CODE_FONT)) {
                return FontPrefs.getCodeFont();
            }
            return fontItem.getCustomFont();
        }
        return DEFAULT_TEXT_FONT;
    }

    public static String getComponentsUsingDesktopFont(String string) {
        String string2 = "";
        for (int i = 0; i < sComponents.size(); ++i) {
            FontItem fontItem = (FontItem)sComponents.elementAt(i);
            if (!fontItem.getFontType().equals(string)) continue;
            if (!string2.equals("")) {
                string2 = string2 + ", ";
            }
            string2 = string2 + fontItem.getComponentName();
        }
        return string2;
    }

    private static void registerComponent(String string) {
        String string2 = (String)FontPrefs.callClassMethod(string, "getDisplayName");
        String string3 = (String)FontPrefs.callClassMethod(string, "getFontPrefsTagName");
        String string4 = (String)FontPrefs.callClassMethod(string, "getDefaultFont");
        if (string2 != null && string3 != null && string4 != null) {
            FontPrefs.registerComponent(string2, string3, string4, null);
        }
    }

    private static void registerComponent(String string, String string2, String string3, Font font) {
        String string4 = "Font" + string2;
        string3 = Prefs.getStringPref(string4, string3);
        font = PrefsAWT.getFontPref(string4 + "Custom", FontPrefs.convertPointToJavaFont(DEFAULT_CUSTOM_FONT));
        sComponents.add(new FontItem(string, string4, string3, font));
    }

    private static Object callClassMethod(String string, String string2) {
        Object object;
        block3: {
            Class<?> clazz = null;
            object = null;
            boolean bl = false;
            try {
                Class[] classArray;
                Method method;
                clazz = Class.forName(string);
                if (clazz != null && (method = clazz.getMethod(string2, classArray = new Class[0])) != null) {
                    Object[] objectArray = new Object[]{};
                    object = method.invoke(null, objectArray);
                }
            }
            catch (Exception exception) {
                if (!bl) break block3;
                System.err.println("FontPrefs: unable to find class " + string + ", with method " + string2 + ".");
            }
        }
        return object;
    }

    public static Vector getRegisteredComponents() {
        return sComponents;
    }

    public static void saveCustomFonts(Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            Font font;
            Font font2;
            String string;
            FontItem fontItem = (FontItem)vector.elementAt(i);
            FontItem fontItem2 = (FontItem)sComponents.elementAt(i);
            String string2 = fontItem2.getFontType();
            if (!string2.equals(string = fontItem.getFontType())) {
                fontItem2.setFontType(string);
                if (string.equals(CODE_FONT)) {
                    FontPrefs.notifyComponentListeners(fontItem2, sCodeFont);
                } else if (string.equals(TEXT_FONT)) {
                    FontPrefs.notifyComponentListeners(fontItem2, sTextFont);
                } else {
                    FontPrefs.notifyComponentListeners(fontItem2, fontItem.fCustomFont);
                }
                Prefs.setStringPref(fontItem2.getPrefsTag(), string);
            }
            if (!string.equals(CUSTOM_FONT) || (font2 = fontItem2.getCustomFont()).equals(font = fontItem.getCustomFont())) continue;
            fontItem2.setCustomFont(fontItem.fCustomFont);
            FontPrefs.notifyComponentListeners(fontItem2, fontItem.fCustomFont);
            PrefsAWT.setFontPref(fontItem.getPrefsTag() + "Custom", fontItem.fCustomFont);
        }
    }

    private static void notifyComponentListeners(FontItem fontItem, Font font) {
        Vector vector = fontItem.getFontListeners();
        for (int i = 0; i < vector.size(); ++i) {
            FontPrefs.notifyListener((FontListener)vector.elementAt(i), font);
        }
    }

    public static Font getCodeFont() {
        return sCodeFont;
    }

    public static Font getTextFont() {
        return FontPrefs.isTextFontSystemFont() ? FontUtils.getSystemUIFont() : sTextFont;
    }

    public static boolean isTextFontSystemFont() {
        return sTextUseSystemFont;
    }

    public static void setTextUseSystemFont(boolean bl) {
        if (sTextUseSystemFont != bl) {
            sTextUseSystemFont = bl;
            Prefs.setBooleanPref("GeneralTextUseSystemFont", bl);
        }
    }

    public static void setCodeFont(Font font) {
        Font font2 = FontPrefs.convertPointToJavaFont(font);
        if (!font2.equals(sCodeFont)) {
            sCodeFont = font2;
            Prefs.setFontPref("GeneralCodeFont", font);
            FontPrefs.notifyListeners(CODE_FONT, sCodeFont);
        }
    }

    public static void setTextFont(Font font) {
        Font font2 = FontPrefs.convertPointToJavaFont(font);
        if (!font2.equals(sTextFont)) {
            sTextFont = font2;
            Prefs.setFontPref("GeneralTextFont", font);
            FontPrefs.notifyListeners(TEXT_FONT, sTextFont);
        }
    }

    public static void addTextFontListener(FontListener fontListener) {
        sFontListeners.add(new FontListenerItem(TEXT_FONT, fontListener));
    }

    public static void addCodeFontListener(FontListener fontListener) {
        sFontListeners.add(new FontListenerItem(CODE_FONT, fontListener));
    }

    public static void removeTextFontListener(FontListener fontListener) {
        for (int i = 0; i < sFontListeners.size(); ++i) {
            FontListenerItem fontListenerItem = (FontListenerItem)sFontListeners.elementAt(i);
            if (!fontListenerItem.getFontListener().equals(fontListener) || !fontListenerItem.getFontType().equals(TEXT_FONT)) continue;
            sFontListeners.remove(i);
            break;
        }
    }

    public static void removeCodeFontListener(FontListener fontListener) {
        for (int i = 0; i < sFontListeners.size(); ++i) {
            FontListenerItem fontListenerItem = (FontListenerItem)sFontListeners.elementAt(i);
            if (!fontListenerItem.getFontListener().equals(fontListener) || !fontListenerItem.getFontType().equals(CODE_FONT)) continue;
            sFontListeners.remove(i);
            break;
        }
    }

    private static void notifyListeners(String string, Font font) {
        if (SwingUtilities.isEventDispatchThread()) {
            FontPrefs.notifyListenersMethod(string, font);
        } else {
            SwingUtilities.invokeLater(new NotifyListenersThread(string, font));
        }
    }

    private static void notifyListenersMethod(String string, Font font) {
        Object object;
        Object object2;
        int n;
        for (n = 0; n < sComponents.size(); ++n) {
            object2 = (FontItem)sComponents.elementAt(n);
            if (!((FontItem)object2).getFontType().equals(string)) continue;
            object = ((FontItem)object2).getFontListeners();
            for (int i = 0; i < ((Vector)object).size(); ++i) {
                ((FontListener)((Vector)object).elementAt(i)).fontChanged(font);
            }
        }
        for (n = 0; n < sFontListeners.size(); ++n) {
            object2 = (FontListenerItem)sFontListeners.elementAt(n);
            if (!((FontListenerItem)object2).getFontType().equals(string)) continue;
            object = ((FontListenerItem)object2).getFontListener();
            object.fontChanged(font);
        }
    }

    private static void notifyListener(FontListener fontListener, Font font) {
        if (SwingUtilities.isEventDispatchThread()) {
            FontPrefs.notifyListenerMethod(fontListener, font);
        } else {
            SwingUtilities.invokeLater(new NotifyListenerThread(fontListener, font));
        }
    }

    private static void notifyListenerMethod(FontListener fontListener, Font font) {
        fontListener.fontChanged(font);
    }

    static {
        sComponents = new Vector();
        sFontListeners = new Vector();
        int n = 10;
        if (PlatformInfo.isMacintosh()) {
            n = 12;
        }
        DEFAULT_CODE_FONT = new Font("Monospaced", 0, n);
        DEFAULT_TEXT_FONT = FontPrefs.convertJavaToPointFont(FontUtils.getSystemUIFont());
        DEFAULT_CUSTOM_FONT = FontPrefs.convertJavaToPointFont(FontUtils.getDefaultReadingFont());
        sCodeFont = FontPrefs.convertPointToJavaFont(PrefsAWT.getFontPref("GeneralCodeFont", DEFAULT_CODE_FONT));
        sTextFont = FontPrefs.convertPointToJavaFont(PrefsAWT.getFontPref("GeneralTextFont", DEFAULT_TEXT_FONT));
        sTextUseSystemFont = Prefs.getBooleanPref("GeneralTextUseSystemFont", true);
        if (!Prefs.exists("GeneralTextUseSystemFont") && !sTextFont.equals(FontPrefs.convertPointToJavaFont(DEFAULT_TEXT_FONT))) {
            sTextUseSystemFont = false;
        }
        if (!MJUtilities.validateFont((Font)sCodeFont)) {
            sCodeFont = FontPrefs.convertPointToJavaFont(DEFAULT_CODE_FONT);
        }
        if (!MJUtilities.validateFont((Font)sTextFont)) {
            sTextFont = FontPrefs.convertPointToJavaFont(DEFAULT_TEXT_FONT);
        }
        FontPrefs.registerComponent("com.mathworks.mde.cmdwin.CmdWinPrefs");
        FontPrefs.registerComponent("com.mathworks.mde.cmdhist.CmdHistoryPrefs");
        FontPrefs.registerComponent("com.mathworks.mde.editor.EditorFontPrefs");
        FontPrefs.registerComponent("com.mathworks.mde.help.HelpNavigatorFontPrefs");
        FontPrefs.registerComponent("com.mathworks.mlwidgets.html.HTMLRendererFontPrefs");
        FontPrefs.registerComponent("com.mathworks.mde.explorer.ExplorerPrefs");
        FontPrefs.registerComponent("com.mathworks.mde.workspace.WorkspaceFontPrefs");
        FontPrefs.registerComponent("com.mathworks.mde.array.ArrayEditorFontPrefs");
        FontPrefs.registerComponent("com.mathworks.mde.functionbrowser.FunctionBrowserFontPrefs");
    }

    public static class FontItem {
        private String fComponentName;
        private String fPrefsTag;
        private String fFontType;
        private Font fCustomFont;
        private Vector fListener = new Vector();

        public FontItem(String string, String string2, String string3, Font font) {
            this.fComponentName = string;
            this.fPrefsTag = string2;
            this.fFontType = string3;
            this.fCustomFont = font;
        }

        public String getComponentName() {
            return this.fComponentName;
        }

        public String getPrefsTag() {
            return this.fPrefsTag;
        }

        public String getFontType() {
            return this.fFontType;
        }

        public Font getCustomFont() {
            return this.fCustomFont;
        }

        public void setFontType(String string) {
            this.fFontType = string;
        }

        public void setCustomFont(Font font) {
            this.fCustomFont = font;
        }

        public Vector getFontListeners() {
            return this.fListener;
        }

        public void addFontListener(FontListener fontListener) {
            this.fListener.addElement(fontListener);
        }

        public void removeFontListener(FontListener fontListener) {
            this.fListener.removeElement(fontListener);
        }

        public String toString() {
            return this.fComponentName;
        }
    }

    private static class FontListenerItem {
        private String fFontType;
        private FontListener fListener;

        FontListenerItem(String string, FontListener fontListener) {
            this.fFontType = string;
            this.fListener = fontListener;
        }

        public String getFontType() {
            return this.fFontType;
        }

        public FontListener getFontListener() {
            return this.fListener;
        }
    }

    private static class NotifyListenerThread
    implements Runnable {
        private FontListener fListener;
        private Font fNewFont;

        NotifyListenerThread(FontListener fontListener, Font font) {
            this.fListener = fontListener;
            this.fNewFont = font;
        }

        public void run() {
            FontPrefs.notifyListenerMethod(this.fListener, this.fNewFont);
        }
    }

    private static class NotifyListenersThread
    implements Runnable {
        private String fFontType;
        private Font fNewFont;

        NotifyListenersThread(String string, Font font) {
            this.fFontType = string;
            this.fNewFont = font;
        }

        public void run() {
            FontPrefs.notifyListenersMethod(this.fFontType, this.fNewFont);
        }
    }
}

