/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.services;

import com.mathworks.services.PrefEvent;
import com.mathworks.services.PrefListener;
import com.mathworks.services.Prefs;
import com.mathworks.services.PrefsAWT;
import java.awt.Color;
import java.awt.SystemColor;
import java.util.Vector;
import javax.swing.SwingUtilities;

public class ColorPrefs {
    public static final String TEXT_COLOR = "ColorsText";
    public static final String BACKGROUND_COLOR = "ColorsBackground";
    public static final String USE_SYSTEM_COLORS = "ColorsUseSystem";
    public static final String M_COLORS = "Colors_M_";
    public static final String HTML_COLORS = "Colors_HTML_";
    private static final String USE_MLINT_AUTOFIX_BACKGROUND = "ColorsUseMLintAutoFixBackground";
    public static final String MLINT_AUTOFIX_BACKGROUND_COLOR = "ColorsMLintAutoFixBackground";
    public static final Color purple = new Color(160, 32, 240);
    public static final Color green = new Color(34, 139, 34);
    private static final String[] CATEGORIES = new String[]{"Keywords", "Comments", "Strings", "UnterminatedStrings", "SystemCommands", "Errors", "HTMLLinks"};
    private static final Color[] PALETTE = new Color[]{Color.blue, green, purple, Color.red.darker(), Color.orange.darker(), Color.red};
    public static final String[] M_CATEGORIES = new String[]{"Colors_M_" + CATEGORIES[0], "Colors_M_" + CATEGORIES[1], "Colors_M_" + CATEGORIES[2], "Colors_M_" + CATEGORIES[3], "Colors_M_" + CATEGORIES[4], "Colors_M_" + CATEGORIES[5]};
    public static final String[] HTML_CATEGORIES = new String[]{"Colors_HTML_" + CATEGORIES[6]};
    public static Color DEFAULT_TEXT_COLOR = Color.black;
    public static Color DEFAULT_BACKGROUND_COLOR = Color.white;
    public static Color[] M_DEFAULT_COLORS = new Color[]{PALETTE[0], PALETTE[1], PALETTE[2], PALETTE[3], PALETTE[4], PALETTE[5]};
    private static Vector fColorListeners = new Vector();

    public static void addColorListener(String string, PrefListener prefListener) {
        fColorListeners.addElement(new ColorListener(string, prefListener));
    }

    public static void removeColorListener(String string, PrefListener prefListener) {
        for (int i = 0; i < fColorListeners.size(); ++i) {
            ColorListener colorListener = (ColorListener)fColorListeners.elementAt(i);
            if (!colorListener.getType().equals(string) || !colorListener.getListener().equals(prefListener)) continue;
            fColorListeners.remove(i);
            break;
        }
    }

    public static void setColorPref(String string, Color color) {
        PrefsAWT.setColorPref(string, color);
    }

    public static Color getColorPref(String string) {
        return PrefsAWT.getColorPref(string, ColorPrefs.getDefaultColor(string));
    }

    public static Color getDefaultColor(String string) {
        Color color = Color.black;
        if (string.startsWith(M_COLORS)) {
            for (int i = 0; i < M_CATEGORIES.length; ++i) {
                if (!M_CATEGORIES[i].equals(string)) continue;
                color = M_DEFAULT_COLORS[i];
                break;
            }
        } else if (string.startsWith(HTML_COLORS)) {
            color = Prefs.getColorPref("CommandWindowLinkColor", ColorPrefs.getDefaultHyperlinkColor());
        } else if (string.equals(MLINT_AUTOFIX_BACKGROUND_COLOR)) {
            color = ColorPrefs.getDefaultMLintAutofixColor();
        }
        return color;
    }

    public static Color getDefaultHyperlinkColor() {
        return Color.blue;
    }

    public static Color getDefaultMLintAutofixColor() {
        return new Color(238, 225, 180);
    }

    public static boolean isMLintAutoFixBackgroundEnabled() {
        return Prefs.getBooleanPref(USE_MLINT_AUTOFIX_BACKGROUND, ColorPrefs.getDefaultMLintAutoFixBackgroundEnabled());
    }

    public static boolean getDefaultMLintAutoFixBackgroundEnabled() {
        return true;
    }

    public static void setMLintAutoFixBackgroundEnabled(boolean bl) {
        Prefs.setBooleanPref(USE_MLINT_AUTOFIX_BACKGROUND, bl);
    }

    public static void addUseMLintAutoFixBackgroundListener(PrefListener prefListener) {
        Prefs.addListener(prefListener, USE_MLINT_AUTOFIX_BACKGROUND);
    }

    public static void removeUseMLintAutoFixBackgroundListener(PrefListener prefListener) {
        Prefs.removeListener(prefListener, USE_MLINT_AUTOFIX_BACKGROUND);
    }

    public static Color getTextColor() {
        if (ColorPrefs.getUseSystemColors()) {
            return ColorPrefs.getSystemTextColor();
        }
        return PrefsAWT.getColorPref(TEXT_COLOR, DEFAULT_TEXT_COLOR);
    }

    public static Color getBackgroundColor() {
        if (ColorPrefs.getUseSystemColors()) {
            return ColorPrefs.getSystemBackgroundColor();
        }
        return PrefsAWT.getColorPref(BACKGROUND_COLOR, DEFAULT_BACKGROUND_COLOR);
    }

    public static Color getSystemTextColor() {
        return SystemColor.textText;
    }

    public static Color getSystemBackgroundColor() {
        return SystemColor.text;
    }

    private static boolean getUseSystemColors() {
        return Prefs.getBooleanPref(USE_SYSTEM_COLORS, true);
    }

    private static void notifyColorListenersMethod(String string) {
        for (int i = 0; i < fColorListeners.size(); ++i) {
            ColorListener colorListener = (ColorListener)fColorListeners.elementAt(i);
            if (!colorListener.getType().equals(string)) continue;
            colorListener.getListener().prefChanged(new PrefEvent(null, string, 1));
        }
    }

    public static void notifyColorListeners(String string) {
        if (SwingUtilities.isEventDispatchThread()) {
            ColorPrefs.notifyColorListenersMethod(string);
        } else {
            SwingUtilities.invokeLater(new NotifyColorListenerThread(string));
        }
    }

    private static class ColorListener {
        private String fType;
        private PrefListener fListener;

        public ColorListener(String string, PrefListener prefListener) {
            this.fType = string;
            this.fListener = prefListener;
        }

        public String getType() {
            return this.fType;
        }

        public PrefListener getListener() {
            return this.fListener;
        }
    }

    private static class NotifyColorListenerThread
    implements Runnable {
        private String fLangType;

        public NotifyColorListenerThread(String string) {
            this.fLangType = string;
        }

        public void run() {
            ColorPrefs.notifyColorListenersMethod(this.fLangType);
        }
    }
}

